/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import twilightforest.util.FeaturePlacers;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.TFTreeGenerator;
import twilightforest.world.components.feature.trees.growers.SnowTreePlacer;

public class TFGenLargeWinter
extends TFTreeGenerator<TFTreeFeatureConfig> {
    public TFGenLargeWinter(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    protected boolean generate(class_5281 world, Random random, class_2338 pos, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, BiConsumer<class_2338, class_2680> decorationPlacer, TFTreeFeatureConfig config) {
        int treeHeight = 35;
        if (random.nextInt(3) == 0) {
            treeHeight += random.nextInt(10);
            if (random.nextInt(8) == 0) {
                treeHeight += random.nextInt(10);
            }
        }
        if (world.method_31601(pos.method_10264() + treeHeight)) {
            return false;
        }
        if (!SnowTreePlacer.isBlockUnderValid((class_3746)world, pos.method_10074())) {
            return false;
        }
        this.buildTrunk((class_1936)world, trunkPlacer, random, pos, treeHeight, config);
        this.makeLeaves((class_1936)world, trunkPlacer, leavesPlacer, random, pos, treeHeight, config);
        int numRoots = 4 + random.nextInt(3);
        float offset = random.nextFloat();
        for (int b = 0; b < numRoots; ++b) {
            FeaturePlacers.buildRoot((class_1936)world, decorationPlacer, random, pos, offset, b, config.rootsProvider);
        }
        return true;
    }

    private void makeLeaves(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, Random random, class_2338 pos, int treeHeight, TFTreeFeatureConfig config) {
        int offGround = 3;
        int leafType = 1;
        for (int dy = 0; dy < treeHeight; ++dy) {
            int radius = this.leafRadius(treeHeight, dy, leafType);
            FeaturePlacers.placeCircleEven((class_3746)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, random, pos.method_10086(offGround + treeHeight - dy), radius, config.leavesProvider);
            this.makePineBranches(world, trunkPlacer, random, pos.method_10086(offGround + treeHeight - dy), radius, config);
        }
    }

    private void makePineBranches(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, Random rand, class_2338 pos, int radius, TFTreeFeatureConfig config) {
        int branchLength = radius > 4 ? radius - 1 : radius - 2;
        switch (pos.method_10264() % 2) {
            case 0: {
                for (int i = 1; i <= branchLength; ++i) {
                    this.placeLogAt(trunkPlacer, rand, pos.method_10069(-i, 0, 0), class_2350.class_2351.field_11048, config);
                    this.placeLogAt(trunkPlacer, rand, pos.method_10069(0, 0, i + 1), class_2350.class_2351.field_11051, config);
                    this.placeLogAt(trunkPlacer, rand, pos.method_10069(i + 1, 0, 1), class_2350.class_2351.field_11048, config);
                    this.placeLogAt(trunkPlacer, rand, pos.method_10069(1, 0, -i), class_2350.class_2351.field_11051, config);
                }
                break;
            }
            case 1: {
                for (int i = 1; i <= branchLength; ++i) {
                    this.placeLogAt(trunkPlacer, rand, pos.method_10069(-1, 0, 1), class_2350.class_2351.field_11048, config);
                    this.placeLogAt(trunkPlacer, rand, pos.method_10069(1, 0, i + 1), class_2350.class_2351.field_11051, config);
                    this.placeLogAt(trunkPlacer, rand, pos.method_10069(i + 1, 0, 0), class_2350.class_2351.field_11048, config);
                    this.placeLogAt(trunkPlacer, rand, pos.method_10069(0, 0, -i), class_2350.class_2351.field_11051, config);
                }
                break;
            }
        }
    }

    private void placeLogAt(BiConsumer<class_2338, class_2680> trunkPlacer, Random rand, class_2338 pos, class_2350.class_2351 axis, TFTreeFeatureConfig config) {
        trunkPlacer.accept(pos, (class_2680)config.trunkProvider.method_23455(rand, pos).method_11657((class_2769)class_2465.field_11459, (Comparable)axis));
    }

    private int leafRadius(int treeHeight, int dy, int functionType) {
        return switch (functionType) {
            case 1 -> (int)(4.0f * (float)dy / (float)treeHeight + 0.75f * (float)dy % 3.0f);
            case 99 -> (treeHeight - dy / 2 - 1) % 4;
            default -> (dy - 1) % 4;
        };
    }

    private void buildTrunk(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, Random rand, class_2338 pos, int treeHeight, TFTreeFeatureConfig config) {
        for (int dy = 0; dy < treeHeight; ++dy) {
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, rand, pos.method_10069(0, dy, 0), config.trunkProvider);
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, rand, pos.method_10069(1, dy, 0), config.trunkProvider);
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, rand, pos.method_10069(0, dy, 1), config.trunkProvider);
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, rand, pos.method_10069(1, dy, 1), config.trunkProvider);
        }
    }
}

